///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains misc timer related code.
 *	\file		IceTimer.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICETIMER_H__
#define __ICETIMER_H__

	//! Timer commands
	enum ICECORE_API TimerCommand
	{
		TIMER_RESET				= 0,			//!< Reset the timer
		TIMER_START				= 1,			//!< Start the timer
		TIMER_STOP				= 2,			//!< Stop (or pause) the timer
		TIMER_ADVANCE			= 3,			//!< Advance the timer by 0.1 seconds
		TIMER_GETABSOLUTETIME	= 4,			//!< Get the absolute system time
		TIMER_GETAPPTIME		= 5,			//!< Get the current time
		TIMER_GETELAPSEDTIME	= 6,			//!< Get the time that elapsed between TIMER_GETELAPSEDTIME calls
		TIMER_FORCE_DWORD		= 0x7fffffff
	};

	ICECORE_API float Timer(TimerCommand command);

#endif // __ICETIMER_H__
